/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.map;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.screens.DungeonMapScreen;

public class LegendItem {
    private static final float ICON_X = 1575.0f * Settings.scale;
    private static final float TEXT_X = 1670.0f * Settings.scale;
    private static final float Y = 500.0f * Settings.scale;
    private static final float SPACE_Y = 58.0f * Settings.scale;
    private Texture img;
    private static final int W = 128;
    private int index;
    private String label;
    private String header;
    private String body;
    private Hitbox hb = new Hitbox(230.0f * Settings.scale, 54.0f * Settings.scale);

    public LegendItem(String label, Texture img, String tipHeader, String tipBody, int index) {
        this.label = label;
        this.img = img;
        this.header = tipHeader;
        this.body = tipBody;
        this.index = index;
    }

    public void update() {
        this.hb.update();
        if (this.hb.hovered) {
            TipHelper.renderGenericTip(ICON_X - 380.0f * Settings.scale, this.hb.cY, this.header, this.body);
        }
    }

    public void render(SpriteBatch sb, Color c) {
        sb.setColor(c);
        if (this.hb.hovered) {
            sb.draw(this.img, ICON_X - 64.0f, Y - SPACE_Y * (float)this.index + 100.0f * Settings.scale - DungeonMapScreen.offsetY / 50.0f - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale / 1.2f, Settings.scale / 1.2f, 0.0f, 0, 0, 128, 128, false, false);
        } else {
            sb.draw(this.img, ICON_X - 64.0f, Y - SPACE_Y * (float)this.index + 100.0f * Settings.scale - DungeonMapScreen.offsetY / 50.0f - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, Settings.scale / 1.65f, Settings.scale / 1.65f, 0.0f, 0, 0, 128, 128, false, false);
        }
        FontHelper.renderFontLeftTopAligned(sb, FontHelper.eventBodyText, this.label, TEXT_X - 50.0f * Settings.scale, Y - SPACE_Y * (float)this.index + 113.0f * Settings.scale - DungeonMapScreen.offsetY / 50.0f, c);
        this.hb.move(TEXT_X, Y - SPACE_Y * (float)this.index + 100.0f * Settings.scale - DungeonMapScreen.offsetY / 50.0f);
        this.hb.render(sb);
    }
}

